<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use Illuminate\Database\Capsule\Manager as DB;

include_once('../../../init.php');
include_once('functions.php');
include_once('hooks.php');

function vpncheckAffexists($clientid) {
    $data = DB::table('tblaffiliates')
            ->where('clientid', $clientid)
            ->get();
    $clientemail = DB::table('tblclients')
                    ->join('tblaffiliates', 'tblaffiliates.clientid', '=', 'tblclients.id')
                    ->where('tblaffiliates.id', '=', $data[0]->affiliatesid)
                    ->select('tblclients.email')->get();

    if (isset($clientemail[0]->email))
        return $clientemail[0]->email;
    else
        return true;
}

function getSystemURL() {
    $configData = DB::table('tblconfiguration')->where('setting', 'SystemURL')->select('value')->get();
    return $configData[0]->value;
}

function vpnservernoapi_MetaData() {
    return array(
        'DisplayName' => 'VPN Module',
        'APIVersion' => '1.1', // Use API Version 1.1
            //'RequiresServer' => true, // Set true if module requires a server to work
            //'DefaultNonSSLPort' => '1111', // Default Non-SSL Connection Port
            //'DefaultSSLPort' => '1112', // Default SSL Connection Port
            //'ServiceSingleSignOnLabel' => 'Login to Panel as User',
            //'AdminSingleSignOnLabel' => 'Login to Panel as Admin',
    );
}

function randomPasswordnoapi() {
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 8; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}

function vpnencryptPass($oldpass) {
    $command = 'EncryptPassword';
    $postData = array(
        'password2' => $oldpass,
    );
    $encPassword = localAPI($command, $postData, '');
    $encPassword = $encPassword['password'];
    return $encPassword;
}

function vpnservernoapi_ConfigOptions() {

    $licenseinfo = vpnservernoapi_CheckLicenseByKey();
    if ($licenseinfo['status'] == 'Active') {
        return array(
            'Product Type' => array(
                'Type' => 'dropdown',
                'Options' => ['member' => 'VPN Account', 'resellerCredits' => 'Reseller Credits', 'resellerAccount' => 'Reseller Account', 'superresellerAccount' => 'Super Reseller Account'],
                'Description' => 'Select Product Type',
            ),
            'Assign Credits' => array(
                'Type' => 'text',
                'Description' => 'Assign Credits to Reseller',
            ),
            'Max Connections' => array(
                "Type" => "text", # Dropdown Choice of Options
                'Description' => 'Number of devices are allowed to connect at the same time',
            ),
            'Set Server' => array(
                'Type' => 'text',
                'Description' => '<p class="showserverlist" onclick="showserverlist()">Click Here to select server to assign to this product</p>',
            )
           /* ,
            'Max Speed (Download/Upload)' => array(
                "Type" => "text", # Dropdown Choice of Options
                'Description' => '<br />Enter Speed in this format "15M/5M" to avoid errors. (Leave Blank if don\'t want to limit speed)',
            ),
                /* "Usage Limit" => array(
                  "Type" => "text",
                  "Size" => "40",
                  "Description" => '<br>In GB. 0 or blank to disable'
                  ), */
                /* "Daily usage report" => array("Type" => "yesno", "Description" => "Tick to Send Email"),
                  "Weekly usage report" => array("Type" => "yesno", "Description" => "Tick to Send Email"), */
        );
    } else {
        return array(
            'licenseKeyStatus' => array(
                'FriendlyName' => 'License Key Status',
                'Description' => "<span style='color:red;'>Invalid or Expired license key.<span>",
                'Size' => 80
            )
        );
    }
}

function vpnservernoapi_CreateAccount(array $params) {

    $licenseinfo = vpnservernoapi_CheckLicenseByKey();
    $data = DB::table('mod_vpn_settings')->get();
    $settings = array();
    foreach ($data as $val) {
        $settings[$val->settings] = $val->value;
    }

    $username = (!empty($params['customfields']['Username'])) ? $params['customfields']['Username'] : custom_randomchar();
    $password = '';
    if ($settings['passwordtype'] == 'random') {
        $password = (!empty($params['customfields']['Password'])) ? $params['customfields']['Password'] : custom_randomchar();
    } else {
        $password = $settings['staticPass'];
    }
    $encryptNewPass = vpnencryptPass($password);
    $status = $params['status'];
    $productType = $params['producttype'];
    $userid = $params['userid'];
    $pid = $params['pid'];
    $serviceid = $params["serviceid"];


    if ($productType == 'reselleraccount') {
        if ($params['configoption1'] == 'resellerAccount') {
            $checkaff = vpncheckAffexists($userid);
            if ($checkaff) {
                $updateClient = DB::table('tblclients')->where('id', $userid)->update(['groupid' => 1]);
                $command = 'AffiliateActivate';
                $postData = array(
                    'userid' => $userid,
                );


                $results = localAPI($command, $postData);
                if ($results['result'] !== 'success') {
                    return 'error! Unable to create reseller';
                }
                if ($status !== 'Active') {
                    $command = 'AddCredit';
                    $postData = array(
                        'clientid' => $userid,
                        'description' => 'Client buy credits',
                        'amount' => $params['configoption2'],
                    );
                }


                $results = localAPI($command, $postData);
                if ($results['result'] !== 'success') {
                    return 'error! Unable to add credits';
                }
            } else {
                return 'User' . $checkaff . 'Already Exists';
            }
        } else if ($params['configoption1'] == 'superresellerAccount') {

            $checkaff = vpncheckAffexists($userid);

            if ($checkaff) {
                $updateClient = DB::table('tblclients')->where('id', $userid)->update(['groupid' => 2]);
                $command = 'AffiliateActivate';
                $postData = array(
                    'userid' => $userid,
                );


                $results = localAPI($command, $postData);
                if ($results['result'] !== 'success') {
                    return 'error! Unable to create super reseller';
                }
                if ($status !== 'Active') {
                    $command = 'AddCredit';
                    $postData = array(
                        'clientid' => $userid,
                        'description' => 'Client buy credits',
                        'amount' => $params['configoption2'],
                    );
                }


                $results = localAPI($command, $postData);
                if ($results['result'] !== 'success') {
                    return 'error! Unable to add credits';
                }
            } else {
                return 'User' . $checkaff . 'Already Exists';
            }
        }
    } else if ($params['configoption1'] == 'resellerCredits') {
        $command = 'AddCredit';
        $postData = array(
            'clientid' => $userid,
            'description' => 'Client buy credits',
            'amount' => $params['configoption2'],
        );


        $results = localAPI($command, $postData);
        if ($results['result'] !== 'success') {
            return 'error';
        }
    } else {


        //echo $password; die('--');
        if ($licenseinfo['status'] != 'Active')
            return "Invalid or expired license key. - Please check VPN Panel addon configuration";



        /* if ($status == 'Active') {
          return 'User ' . $username . ' Already Active';
          } */

        $radcheckcount = DB::table('radcheck')->where('username', $username)->count();

        if ($radcheckcount > 0) {
            return "This {$username} usersername is already taken";
        }
        if (!empty($username) && !empty($encryptNewPass)) {
            DB::table('tblhosting')->where('id', $serviceid)->update(['username' => $username]);
            DB::table('tblhosting')->where('id', $serviceid)->update(['password' => $encryptNewPass]);
        }

        $radrplyPostData = array('username' => $username, 'attribute' => 'Idle-timeout', 'value' => '120', 'op' => '==');
        $addRadrply = DB::table('radreply')->insert($radrplyPostData);
        if (!$addRadrply) {
            return "Database Query Error Radrply: " . $addRadrply;
        }

        $radPostData = array('username' => $username, 'attribute' => 'Cleartext-Password', 'value' => $password, 'op' => ':=');
        $addRadcheck = DB::table('radcheck')->insert($radPostData);
        if (!$addRadcheck) {
            return "Database Query Error: " . $addRadcheck;
        }

        if (!empty($params['configoption5'])) {
            $radrplyUGData1 = array('groupname' => 'myusergroup', 'username' => $username);
                $addradrplyUGData = DB::table('radusergroup')->insert($radrplyUGData1);
            $radrplycount = DB::table('radreply')->where('username', $username)->where('attribute', 'Mikrotik-Rate-Limit')->count();
            if ($radrplycount == 0) {
                $radrplyPostData1 = array('username' => $username, 'attribute' => 'Mikrotik-Rate-Limit', 'value' => $params['configoption5'], 'op' => ':=');
                $addRadrply1 = DB::table('radreply')->insert($radrplyPostData1);
                
                if (!$addRadrply1) {
                return "Database Query Error Radrply: " . $addRadrply1;
            }
            } else {
                $radrplyPostData1 = array('username' => $username, 'attribute' => 'Mikrotik-Rate-Limit', 'value' => $params['configoption5'], 'op' => ':=');
                $addRadrply1 = DB::table('radreply')->where('attribute', 'Mikrotik-Rate-Limit')->update($radrplyPostData1);
                if (!$addRadrply1) {
                return "Database Query Error Radrply: " . $addRadrply1;
            }
            }
            
        }

        /*
          $raduserPostData = array('username' => $username,'groupname' => '');
          $addRadusergroup = DB::table('radusergroup')->insert($raduserPostData);
          if(!$addRadusergroup)
          {
          return "Database Query Error: " . $addRadusergroup;
          } */

        $radsessionData = array('username' => $username, 'attribute' => 'Simultaneous-Use', 'value' => $params['configoption3'], 'op' => ':=');
        $addRadsession = DB::table('radcheck')->insert($radsessionData);
        if (!$addRadsession) {
            return "Database Query Error: " . $addRadsession;
        }
    }



    /* -----------------------------add-user-sh-script-------------------------------------- */

    /* set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
      require_once __DIR__ . '/phpseclib/Crypt/RC4.php';
      require_once __DIR__ . '/phpseclib/Crypt/Rijndael.php';
      require_once __DIR__ . '/phpseclib/Crypt/Twofish.php';
      require_once __DIR__ . '/phpseclib/Crypt/Blowfish.php';
      require_once __DIR__ . '/phpseclib/Crypt/TripleDES.php';
      require_once __DIR__ . '/phpseclib/Crypt/Random.php';
      require_once __DIR__ . '/phpseclib/Crypt/Hash.php';
      require_once __DIR__ . '/phpseclib/Math/BigInteger.php';
      require_once __DIR__ . '/phpseclib/Net/SSH2.php'; */


    /* $servers = getallservers();

      foreach($servers['Servers'] as $server)
      {
      $serverIP = $server->server_ip;
      $serversshport = $server->sshport;
      $serverPass = base64_decode($server->sshpass);
      $category = $server->server_category;

      if($category == 'ipsec' || $category == 'openvpn_ipsec')
      {
      $ssh = new Net_SSH2($serverIP, $serversshport);
      if (!$ssh->login('root', $serverPass)) {
      return 'LoginFailed';
      }
      $ssh->exec('curl -O https://raw.githubusercontent.com/amansmarters/setup-ipsec-vpn/master/extras/add_vpn_user.sh');
      $ssh->exec('chmod +x add_vpn_user.sh');
      $adduser = $ssh->exec("./add_vpn_user.sh '".$params['username']."' '".$params['password']."' ");
      logModuleCall('VPN Panel Server', 'Add User script', $serverIP, $adduser, '', '');

      }


      }
      foreach($servers['lbServers'] as $server)
      {
      $serverIP = $server->server_ip;
      $serversshport = $server->sshport;
      $serverPass = base64_decode($server->sshpass);
      $category = $server->server_category;

      if($category == 'ipsec' || $category == 'openvpn_ipsec')
      {
      $ssh = new Net_SSH2($serverIP, $serversshport);
      if (!$ssh->login('root', $serverPass)) {
      return 'LoginFailed';
      }

      $ssh->exec('curl -O https://raw.githubusercontent.com/amansmarters/setup-ipsec-vpn/master/extras/add_vpn_user.sh');
      $ssh->exec('chmod +x add_vpn_user.sh');
      $adduser = $ssh->exec("./add_vpn_user.sh '".$params['username']."' '".$params['password']."' ");
      logModuleCall('VPN Panel Server', 'Add User script', $serverIP, $adduser, '', '');

      }


      } */
    /* -----------------------------add-user-sh-script-end---------------------------------- */

    return 'success';
}

function vpnservernoapi_SuspendAccount(array $params) {
    $username = $params['username'];
    if ($params['configoption1'] == 'member') {
        $radcheckcount = DB::table('radcheck')->where('username', $username)->where('attribute', 'Expiration')->count();
        if ($radcheckcount == 0) {
            $radsuspendData = array('username' => $username, 'attribute' => 'Expiration', 'value' => date("d F Y"), 'op' => ':=');
            $addRadsuspend = DB::table('radcheck')->insert($radsuspendData);
            if (!$addRadsuspend) {
                return "Database Query Error: " . $addRadsuspend;
            }
        } else {
            $radsuspendData = array('username' => $username, 'attribute' => 'Expiration', 'value' => date("d F Y"), 'op' => ':=');
            $updateRadsuspend = DB::table('radcheck')->where('username', $username)->where('attribute', 'Expiration')->update($radsuspendData);
            if (!$updateRadsuspend) {
                return "Database Query Error: " . $updateRadsuspend;
            }
        }
    }
    return 'success';
}

function vpnservernoapi_UnsuspendAccount(array $params) {

    $username = $params["username"];
    if ($params['configoption1'] == 'member') {
        $unsuspend = DB::table('radcheck')->where('username', $username)->where('attribute', 'Expiration')->delete();
        if (!$unsuspend) {
            return "Unable to Unsuspend " . $unsuspend;
        }
    }

    return 'success';
}

function vpnservernoapi_TerminateAccount(array $params) {
    /* -----------------------------delete-user-sh-script-------------------------------------- */

    /* set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
      require_once __DIR__ . '/phpseclib/Crypt/RC4.php';
      require_once __DIR__ . '/phpseclib/Crypt/Rijndael.php';
      require_once __DIR__ . '/phpseclib/Crypt/Twofish.php';
      require_once __DIR__ . '/phpseclib/Crypt/Blowfish.php';
      require_once __DIR__ . '/phpseclib/Crypt/TripleDES.php';
      require_once __DIR__ . '/phpseclib/Crypt/Random.php';
      require_once __DIR__ . '/phpseclib/Crypt/Hash.php';
      require_once __DIR__ . '/phpseclib/Math/BigInteger.php';
      require_once __DIR__ . '/phpseclib/Net/SSH2.php';


      $servers = getallservers();

      foreach($servers['Servers'] as $server)
      {
      $serverIP = $server->server_ip;
      $serversshport = $server->sshport;
      $serverPass = base64_decode($server->sshpass);
      $category = $server->server_category;

      if($category == 'ipsec' || $category == 'openvpn_ipsec')
      {
      $ssh = new Net_SSH2($serverIP, $serversshport);
      if (!$ssh->login('root', $serverPass)) {
      return 'LoginFailed';
      }
      $ssh->exec('curl -O https://raw.githubusercontent.com/amansmarters/setup-ipsec-vpn/master/extras/del_vpn_user.sh');
      $ssh->exec('chmod +x del_vpn_user.sh');
      $deluser = $ssh->exec("./del_vpn_user.sh '".$params['username']."'");
      logModuleCall('VPN Panel Server', 'delete User script', $serverIP, $deluser, '', '');

      }


      }
      foreach($servers['lbServers'] as $server)
      {
      $serverIP = $server->server_ip;
      $serversshport = $server->sshport;
      $serverPass = base64_decode($server->sshpass);
      $category = $server->server_category;

      if($category == 'ipsec' || $category == 'openvpn_ipsec')
      {
      $ssh = new Net_SSH2($serverIP, $serversshport);
      if (!$ssh->login('root', $serverPass)) {
      return 'LoginFailed';
      }

      $ssh->exec('curl -O https://raw.githubusercontent.com/amansmarters/setup-ipsec-vpn/master/extras/del_vpn_user.sh');
      $ssh->exec('chmod +x del_vpn_user.sh');
      $adduser = $ssh->exec("./del_vpn_user.sh '".$params['username']."' '".$params['password']."' ");
      logModuleCall('VPN Panel Server', 'delete User script', $serverIP, $adduser, '', '');

      }


      } */

    /* -----------------------------delete-user-sh-script-end---------------------------------- */


    $username = $params["username"];


    /* $deleteradusergroup = DB::table('radusergroup')->where('username', $username)->delete();
      if(!$deleteradusergroup)
      {
      return "Unable to Terminate User Group " . $deleteradusergroup;
      } */
    $productType = $params['producttype'];
    $userid = $params['userid'];
    if ($productType == 'reselleraccount') {
        DB::table('tblclients')->where('id', $userid)->update(['groupid' => 0, 'credit' => 0]);
        $deleteAff = DB::table('tblaffiliates')->where('clientid', $userid)->delete();
    } elseif ($params['configoption1'] == 'resellerCredits') {
        
    } else {
        $deleteradcheck = DB::table('radcheck')->where('username', $username)->delete();

        $removeRadrply = DB::table('radreply')->where('username', $username)->delete();
        //$deleteradreply = DB::table('radreply')->where('username', $username)->delete();
    }


    return 'success';
}

/* function vpnservernoapi_ChangePassword(array $params)
  {
  try {
  // Call the service's change password function, using the values
  // provided by WHMCS in `$params`.
  //
  // A sample `$params` array may be defined as:
  //
  // ```
  // array(
  //     'username' => 'The service username',
  //     'password' => 'The new service password',
  // )
  // ```
  } catch (Exception $e) {
  // Record the error in WHMCS's module log.
  logModuleCall(
  'vpnservernoapi',
  __FUNCTION__,
  $params,
  $e->getMessage(),
  $e->getTraceAsString()
  );

  return $e->getMessage();
  }

  return 'success';
  }


  function vpnservernoapi_ChangePackage(array $params)
  {
  try {
  // Call the service's change password function, using the values
  // provided by WHMCS in `$params`.
  //
  // A sample `$params` array may be defined as:
  //
  // ```
  // array(
  //     'username' => 'The service username',
  //     'configoption1' => 'The new service disk space',
  //     'configoption3' => 'Whether or not to enable FTP',
  // )
  // ```
  } catch (Exception $e) {
  // Record the error in WHMCS's module log.
  logModuleCall(
  'vpnservernoapi',
  __FUNCTION__,
  $params,
  $e->getMessage(),
  $e->getTraceAsString()
  );

  return $e->getMessage();
  }

  return 'success';
  }


  function vpnservernoapi_TestConnection(array $params)
  {
  try {
  // Call the service's connection test function.

  $success = true;
  $errorMsg = '';
  } catch (Exception $e) {
  // Record the error in WHMCS's module log.
  logModuleCall(
  'vpnservernoapi',
  __FUNCTION__,
  $params,
  $e->getMessage(),
  $e->getTraceAsString()
  );

  $success = false;
  $errorMsg = $e->getMessage();
  }

  return array(
  'success' => $success,
  'error' => $errorMsg,
  );
  }

 */

function vpnservernoapi_AdminCustomButtonArray() {
    return array(
            //"Update" => "update1",
            // "Button 2 Display Value" => "buttonTwoFunction",
    );
}

function vpnservernoapi_update1(array $params) {
    
}

function vpnservernoapi_update(array $params) {

    $licenseinfo = vpnservernoapi_CheckLicenseByKey();
    $newusername = (!empty($_REQUEST['uname'])) ? $_REQUEST['uname'] : custom_randomchar();
    $newpassword = (!empty($_REQUEST['pws'])) ? $_REQUEST['pws'] : custom_randomchar();
    $serviceid = $params["serviceid"];
    $oldusername = (!empty($_REQUEST['olduname'])) ? $_REQUEST['olduname'] : custom_randomchar();
    $oldpassword = (!empty($_REQUEST['oldpws'])) ? $_REQUEST['oldpws'] : custom_randomchar();
    $encryptNewPass = vpnencryptPass($newpassword);

    DB::table('tblhosting')->where('id', $serviceid)->update(['username' => $newusername]);
    DB::table('tblhosting')->where('id', $serviceid)->update(['password' => $encryptNewPass]);

    DB::table('radcheck')->where('username', $oldusername)->where('attribute', 'Simultaneous-Use')->delete();
    DB::table('radcheck')->where('username', $oldusername)->where('attribute', 'Cleartext-Password')->delete();

    $radPostData = array('username' => $newusername, 'attribute' => 'Cleartext-Password', 'value' => $newpassword, 'op' => ':=');
    $addRadcheck = DB::table('radcheck')->insert($radPostData);
    if (!$addRadcheck) {
        return "Database Query Error radcheck: " . $addRadcheck;
    }
    $radsessionData = array('username' => $newusername, 'attribute' => 'Simultaneous-Use', 'value' => $params['configoption3'], 'op' => ':=');
    $addRadsession = DB::table('radcheck')->insert($radsessionData);
    if (!$addRadsession) {
        return "Database Query Error radcheck: " . $addRadsession;
    }
    return 'success';
}

function getallservers() {
    $lbServers = DB::table('lb_server_list')->orderBy('server_id', 'ASC')->get();
    $Servers = DB::table('server_list')->orderBy('server_id', 'ASC')->get();
    return array('lbServers' => $lbServers, 'Servers' => $Servers);
}

function vpnservernoapi_renew(array $params) {
    $sid = $params["serviceid"];
    $renewserv = renewservice($sid);
    return $renewserv;
}

function vpnservernoapi_ClientArea(array $params) {

    $qrcode_image = "";
    // Determine the requested action and set service call parameters based on
    // the action.
    $requestedAction = isset($_REQUEST['customAction']) ? $_REQUEST['customAction'] : '';
    $licenseinfo = vpnservernoapi_CheckLicenseByKey();
    if ($licenseinfo['status'] != 'Active')
        return "Invalid or expired license key. - Please check VPN Panel addon configuration";
    if ($requestedAction == 'downloadcert') {
        $serviceAction = 'get_usage';
        $templateFile = 'templates/downloadcert.tpl';
    } else {
        $serviceAction = 'get_stats';
        $templateFile = 'templates/overview.tpl';
    }
    $serverslist = $params['configoption4'];
    $serversarray = explode(',', $serverslist);
    $s = 0;
    $allserver = array();
    foreach ($serversarray as $server) {
        $allserversData = DB::table('server_list')->where('server_list.server_id', $server)
                ->join('mod_vpn_groups', 'server_list.server_group', '=', 'mod_vpn_groups.id')
                ->select('server_list.*','mod_vpn_groups.groupName')
                ->get();
        
        
        foreach ($allserversData as $server) {
            if ($server->server_category == 'openvpn-ikev2') {
                $allserver[$server->groupName][$s]['file'] = array('ovpn', 'pem');
            }
            if ($server->server_category == 'openvpn') {
                $allserver[$server->groupName][$s]['file'] = array('ovpn');
            }
            if ($server->server_category == 'ikev2') {
                $allserver[$server->groupName][$s]['file'] = array('pem');
            }
            $allserver[$server->groupName][$s]['name'] = $server->server_name;
            $allserver[$server->groupName][$s]['ip'] = $server->server_ip;
            $allserver[$server->groupName][$s]['flag'] = $server->flag;

            $s++;
        }
    }



    if (isset($_POST["generate_code"])) {
        $ServiceIDtoch = $params['serviceid'];
        $FolderTOsaveQrCode = "downloads/";

        //Delete OLD qr Codes images
        $getFiles = glob($FolderTOsaveQrCode . "*.png");
        if (!empty($getFiles)) {
            foreach ($getFiles as $imagesname) {
                $onlyfilename = str_replace($FolderTOsaveQrCode, "", $imagesname);
                if (preg_match(strtoupper('/' . $ServiceIDtoch . 'test/'), strtoupper($onlyfilename))) {
                    unlink($imagesname);
                }
            }
        }
        //Deleting process ends here

        if (file_exists("modules/servers/vpnservernoapi/lib/qr_code/qrlib.php")) {
            $start_digits = custom_randomchar(11);
            $end_digits = custom_randomchar(7);

            $C_Data = DB::table('tblclients')
                    ->where('id', '=', $_SESSION["uid"])
                    ->get();
            $ApiData = DB::table('mod_vpn_api')->where("setting", "=", "apikey")->get();
            $a = (isset($ApiData[0]->value) && !empty($ApiData[0]->value)) ? $ApiData[0]->value : "";
            $e = (isset($C_Data[0]->email) && !empty($C_Data[0]->email)) ? $C_Data[0]->email : "";
            $clientid = (isset($C_Data[0]->id) && !empty($C_Data[0]->id)) ? $C_Data[0]->id : "";
            $r = rand(00000000, 99999999);
            $salt = "KJHGFkugu345*&^klih";
            $tempsc = $e . "*" . $salt . "-" . $a . "-" . $r . "-";
            $mysc = md5($tempsc);


            $returnData = array(
                "sc" => $mysc,
                "e" => $e,
                "r" => $r,
                "u" => $clientid
            );
            $semifinal = json_encode($returnData);
            $finalData = $start_digits . base64_encode($semifinal) . $end_digits;
            include_once("modules/servers/vpnservernoapi/lib/qr_code/qrlib.php");
            $PNG_TEMP_DIR = $FolderTOsaveQrCode;
            $PNG_WEB_DIR = 'temp/';
            if (!file_exists($PNG_TEMP_DIR)) {
                mkdir($PNG_TEMP_DIR, 0777);
            }

            $filename = $PNG_TEMP_DIR . 'test.png';

            $errorCorrectionLevel = "H";
            $matrixPointSize = 6;

            $CodeDATAis = $finalData;
            $filename = $PNG_TEMP_DIR . $ServiceIDtoch . 'test' . md5($CodeDATAis . '|' . $errorCorrectionLevel . '|' . $matrixPointSize) . '.png';
            QRcode::png($CodeDATAis, $filename, $errorCorrectionLevel, $matrixPointSize, 2);
            $qrcode_image = $FolderTOsaveQrCode . basename($filename);
        }
    }
    $downloadovpn = 0;
    $downloadcert = 0;


    try {
        // Call the service's function based on the request action, using the
        // values provided by WHMCS in `$params`.
        $response = array();
        $appdata = array();
        $appdata1 = DB::table('mod_vpn_applinks')->get();
        // print_r($appdata); die();
        foreach ($appdata1 as $app) {
            if ($app->appfor == 'android') {
                $appdata['android'] = $app->applink;
            }
            if ($app->appfor == 'windows') {
                $appdata['windows'] = $app->applink;
            }
            if ($app->appfor == 'ios') {
                $appdata['ios'] = $app->applink;
            }
            if ($app->appfor == 'linux') {
                $appdata['linux'] = $app->applink;
            }
            if ($app->appfor == 'macos') {
                $appdata['macos'] = $app->applink;
            }
        }
        /* $extraVariable1 = 'abc';
          $extraVariable2 = '123'; */

        $serviceUsername = $params['username'];
        $servicePassword = $params['password'];
        $downloadovpnbuttonData = DB::table('tbladdonmodules')->where('module', '=', 'vpnpanel')->where('setting', 'downloadbutton')->get();
        $downloadovpnbutton = $downloadovpnbuttonData[0]->value;
        $data = DB::table('mod_vpn_settings')->get();
        $settings = array();
        foreach ($data as $val) {
            $settings[$val->settings] = $val->value;
        }
        return array(
            'tabOverviewReplacementTemplate' => $templateFile,
            'templateVariables' => array(
                'extracustomfields' => $params['customfields'],
                'appdata' => $appdata,
                'systemURL' => getSystemURL(),
                'serviceid' => $params['serviceid'],
                'vpnusername' => $serviceUsername,
                'vpnpassword' => $servicePassword,
                'qrcode_image' => $qrcode_image,
                'allservers' => $allserver,
                'downloadovpn' => $downloadovpn,
                'downloadcert' => $downloadcert,
                'settings' => $settings,
                'downloadovpnbutton' => $downloadovpnbutton,
                'clientEmail' => $params['clientsdetails']['email'],
            ),
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
                'vpnservernoapi', __FUNCTION__, $params, $e->getMessage(), $e->getTraceAsString()
        );

        // In an error condition, display an error page.
        return array(
            'tabOverviewReplacementTemplate' => 'error.tpl',
            'templateVariables' => array(
                'usefulErrorHelper' => $e->getMessage(),
            ),
        );
    }
}

function vpnservernoapi_ClientAreaCustomButtonArray() {
    /* return array(
      "Action 1 Display Value" => "actionOneFunction",
      "Action 2 Display Value" => "actionTwoFunction",
      ); */
}

function checkuserservice($serviceid) {
    
}

function vpnservernoapi_CheckLicenseByKey() {

    $result = DB::table('tbladdonmodules')->where('module', '=', 'vpnpanel')->get();
    foreach ($result as $row) {
        $settings[$row->setting] = $row->value;
    }
    if ($settings['license']) {
        $localkey = $settings['localkey'];
        $licenseinfo = $result = vpnservernoapi_CheckLicense($settings['license'], $localkey);
        if ($licenseinfo['status'] == 'Active') {
            if (isset($licenseinfo['localkey']) && !empty($licenseinfo['localkey'])) {
                $moduledata = DB::table('tbladdonmodules')
                        ->where('module', '=', 'vpnpanel')
                        ->where('setting', '=', 'localkey')
                        ->get();
                if (isset($moduledata) && !empty($moduledata)) {
                    DB::table('tbladdonmodules')
                            ->where('setting', 'localkey')
                            ->where('module', 'vpnpanel')
                            ->update(['value' => $licenseinfo['localkey']]);
                } else {
                    DB::table('tbladdonmodules')->insert(
                            ['setting' => 'localkey', 'value' => $licenseinfo['localkey'], 'module' => 'vpnpanel']
                    );
                }
            }
        }
        $result['licensekey'] = $settings['license'];
    } else {
        $result['status'] = 'licensekeynotfound';
    }
    return $result;
}

function vpnservernoapi_CheckLicense($licensekey, $localkey = '') {
    $whmcsurl = "https://www.whmcssmarters.com/clients/";
    $licensing_secret_key = "smartersvpnpanel";
    $localkeydays = 14;
    $allowcheckfaildays = 5;
    $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
    $checkdate = date("Ymdhis");
    if (!isset($_SERVER['SERVER_NAME']) && empty($_SERVER['SERVER_NAME'])) {
        $results['status'] = "Active";
        return $results;
    }
    $domain = $_SERVER['SERVER_NAME'];
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $dirpath = dirname(dirname(__DIR__)) . '/addons/vpnpanel';
    $verifyfilepath = 'modules/servers/licensing/verify.php';
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", '', $localkey); // Remove the line breaks
        $localdata = substr($localkey, 0, strlen($localkey) - 32); // Extract License Data
        $md5hash = substr($localkey, strlen($localkey) - 32); // Extract MD5 Hash
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata); // Reverse the string
            $md5hash = substr($localdata, 0, 32); // Extract MD5 Hash
            $localdata = substr($localdata, 32); // Extract License Data
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - $localkeydays, date("Y")));
                if ($originalcheckdate > $localexpiry) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(',', $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(',', $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validdirs = explode(',', $results['validdirectory']);
                    if (!in_array($dirpath, $validdirs)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $responseCode = 0;
        $postfields = array(
            'licensekey' => $licensekey,
            'domain' => $domain,
            'ip' => $usersip,
            'dir' => $dirpath
        );
        if ($check_token)
            $postfields['check_token'] = $check_token;
        $query_string = '';
        foreach ($postfields AS $k => $v) {
            $query_string .= $k . '=' . urlencode($v) . '&';
        }
        if (function_exists('curl_exec')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } else {
            $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
            $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $newlinefeed = "\r\n";
                $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                $header .= "Host: " . $whmcsurl . $newlinefeed;
                $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                $header .= $query_string;
                $data = $line = '';
                @stream_set_timeout($fp, 20);
                @fputs($fp, $header);
                $status = @socket_get_status($fp);
                while (!@feof($fp) && $status) {
                    $line = @fgets($fp, 1024);
                    $patternMatches = array();
                    if (!$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)) {
                        $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                    }
                    $data .= $line;
                    $status = @socket_get_status($fp);
                }
                @fclose($fp);
            }
        }
        if ($responseCode != 200) {
            $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if ($originalcheckdate > $localexpiry) {
                $results = $localkeyresults;
            } else {
                $results = array();
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        } else {
            preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
            $results = array();
            foreach ($matches[1] AS $k => $v) {
                $results[$v] = $matches[2][$k];
            }
        }
        if (!is_array($results)) {
            die("Invalid License Server Response");
        }
        if ($results['md5hash']) {
            if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                $results['status'] = "Invalid";
                $results['description'] = "MD5 Checksum Verification Failed";
                return $results;
            }
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
        }
        $results['remotecheck'] = true;
    }
    unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
    return $results;
}

function custom_randomchar($limit = 10) {
    $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return substr(str_shuffle($permitted_chars), 0, $limit);
}

/* function vpnservernoapi_buttonOneFunction(array $params)
  {
  try {
  // Call the service's function, using the values provided by WHMCS in
  // `$params`.
  } catch (Exception $e) {
  // Record the error in WHMCS's module log.
  logModuleCall(
  'vpnservernoapi',
  __FUNCTION__,
  $params,
  $e->getMessage(),
  $e->getTraceAsString()
  );

  return $e->getMessage();
  }

  return 'success';
  }

  function vpnservernoapi_actionOneFunction(array $params)
  {
  try {
  // Call the service's function, using the values provided by WHMCS in
  // `$params`.
  } catch (Exception $e) {
  // Record the error in WHMCS's module log.
  logModuleCall(
  'vpnservernoapi',
  __FUNCTION__,
  $params,
  $e->getMessage(),
  $e->getTraceAsString()
  );

  return $e->getMessage();
  }

  return 'success';
  } */

function vpnservernoapi_AdminServicesTabFields(array $params) {
    $_SESSION['oldUsername'] = $params['username'];
    $_SESSION['oldPassword'] = $params['password'];
    return 'success';
}

/*function vpnservernoapi_AdminServicesTabFieldsSave(array $params)
      {
        
        //echo '<pre>'; print_r($_REQUEST); die();
        
          
      // Fetch form submission variables.
      $originalFieldValue = isset($_REQUEST['vpnservernoapi_original_uniquefieldname'])
      ? $_REQUEST['vpnservernoapi_original_uniquefieldname']
      : '';

      $newFieldValue = isset($_REQUEST['vpnservernoapi_uniquefieldname'])
      ? $_REQUEST['vpnservernoapi_uniquefieldname']
      : '';

      // Look for a change in value to avoid making unnecessary service calls.
      if ($originalFieldValue != $newFieldValue) {
      try {
      // Call the service's function, using the values provided by WHMCS
      // in `$params`.
      } catch (Exception $e) {
      // Record the error in WHMCS's module log.
      logModuleCall(
      'vpnservernoapi',
      __FUNCTION__,
      $params,
      $e->getMessage(),
      $e->getTraceAsString()
      );

      // Otherwise, error conditions are not supported in this operation.
      }
      }
      }/*


      function vpnservernoapi_ServiceSingleSignOn(array $params)
      {
      try {
      // Call the service's single sign-on token retrieval function, using the
      // values provided by WHMCS in `$params`.
      $response = array();

      return array(
      'success' => true,
      'redirectTo' => $response['redirectUrl'],
      );
      } catch (Exception $e) {
      // Record the error in WHMCS's module log.
      logModuleCall(
      'vpnservernoapi',
      __FUNCTION__,
      $params,
      $e->getMessage(),
      $e->getTraceAsString()
      );

      return array(
      'success' => false,
      'errorMsg' => $e->getMessage(),
      );
      }
      } */

    /* function vpnservernoapi_AdminSingleSignOn(array $params)
      {
      try {
      // Call the service's single sign-on admin token retrieval function,
      // using the values provided by WHMCS in `$params`.
      $response = array();

      return array(
      'success' => true,
      'redirectTo' => $response['redirectUrl'],
      );
      } catch (Exception $e) {
      // Record the error in WHMCS's module log.
      logModuleCall(
      'vpnserver',
      __FUNCTION__,
      $params,
      $e->getMessage(),
      $e->getTraceAsString()
      );

      return array(
      'success' => false,
      'errorMsg' => $e->getMessage(),
      );
      }
      } */




    